# MPPN: Multi-Resolution Periodic Pattern Network For Long-Term Time Series Forecasting

This repo is the official Pytorch implementation of **MPPN: Multi-Resolution Periodic Pattern Network For Long-Term Time Series Forecasting**.




## Updates

- [2023/05/25] We update official codes of MPPN. 

  



## Implementation

All experiment script files are in `./scripts`:

This code is simply built on the code base of [LTSF-Linear](https://github.com/cure-lab/LTSF-Linear). We appreciate the following GitHub repos a lot for their valuable code base or datasets:

The implementation of LTSF-Linear is from https://github.com/cure-lab/LTSF-Linear

The implementation of Autoformer, Informer, Transformer is from https://github.com/thuml/Autoformer

The implementation of FEDformer is from https://github.com/MAZiqing/FEDformer



## MPPN

![image](MPPN.png)



We propose a novel deep learning network architecture, named **Multi-resolution Periodic Pattern Network (MPPN)** for long-term time series forecasting. 

- Firstly, we construct context-aware multi-resolution semantic units of the time series and propose a multi-periodic pattern mining mechanism for capturing the distinctive patterns in time series.
- Secondly, we propose a channel adaptive module to infer the variate embedding (attributes) from data during training and to perform adaptive weighting on the mined patterns. 
- In addition,  we argue that before predicting a time series, it should be evaluated whether the series is predictable or not. Therefore, in this paper, we introduce an entropy-based method for evaluating the predictability of time series and providing an upper bound on how predictable the time series is before carrying out predictions. 



## Getting Started

### Environment Requirements

First, please make sure you have installed Conda. Then, our environment can be installed by:

```
conda create -n MPPN python=3.9.7
conda activate MPPN
pip install -r requirements.txt
```



### Data Preparation

You can obtain all the nine benchmarks from [Google Drive](https://drive.google.com/drive/folders/1ZOYpTUa82_jCcxIdTmyr0LXQfvaM9vIy) provided in Autoformer. All the datasets have been put in the `./dataset` directory.



### Training Example

To train the **MPPN** for multivariate forecasting on all datasets, you can use the script `scripts/EXP-LongForecasting/Linear/MPPN.sh`:

```
sh scripts/EXP-LongForecasting/MPPN.sh
```

It will start to train **TimeModel (MPPN)** by default, the results will be shown in `logs/LongForecasting`. You can specify the name of the model in the script. For univariate forecasting scenario, the corresponding script is put in `scripts/EXP-LongForecasting/Linear/MPPN-s.sh`:






